package zio.aws.waf.model
import zio.aws.waf.model.primitives.{PaginationLimit, NextMarker}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListRulesRequest(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    limit: Optional[PaginationLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListRulesRequest = {
    import ListRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListRulesRequest
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        limit.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ListRulesRequest.ReadOnly =
    zio.aws.waf.model.ListRulesRequest.wrap(buildAwsValue())
}
object ListRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListRulesRequest =
      zio.aws.waf.model.ListRulesRequest(
        nextMarker.map(value => value),
        limit.map(value => value)
      )
    def nextMarker: Optional[NextMarker]
    def limit: Optional[PaginationLimit]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getLimit: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListRulesRequest
  ) extends zio.aws.waf.model.ListRulesRequest.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val limit: Optional[PaginationLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.waf.model.primitives.PaginationLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListRulesRequest
  ): zio.aws.waf.model.ListRulesRequest.ReadOnly = new Wrapper(impl)
}
