package zio.aws.waf.model
import zio.aws.waf.model.primitives.{PaginationLimit, NextMarker}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListWebAcLsRequest(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    limit: Optional[PaginationLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListWebAcLsRequest = {
    import ListWebAcLsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListWebAcLsRequest
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        limit.map(value => PaginationLimit.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.ListWebAcLsRequest.ReadOnly =
    zio.aws.waf.model.ListWebAcLsRequest.wrap(buildAwsValue())
}
object ListWebAcLsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListWebAcLsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.ListWebAcLsRequest =
      zio.aws.waf.model.ListWebAcLsRequest(
        nextMarker.map(value => value),
        limit.map(value => value)
      )
    def nextMarker: Optional[NextMarker]
    def limit: Optional[PaginationLimit]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getLimit: ZIO[Any, AwsError, PaginationLimit] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListWebAcLsRequest
  ) extends zio.aws.waf.model.ListWebAcLsRequest.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.waf.model.primitives.NextMarker(value))
    override val limit: Optional[PaginationLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.waf.model.primitives.PaginationLimit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListWebAcLsRequest
  ): zio.aws.waf.model.ListWebAcLsRequest.ReadOnly = new Wrapper(impl)
}
