package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ResourceId, Negated}
import scala.jdk.CollectionConverters.*
final case class Predicate(
    negated: Negated,
    `type`: zio.aws.waf.model.PredicateType,
    dataId: ResourceId
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.Predicate = {
    import Predicate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.Predicate
      .builder()
      .negated(Negated.unwrap(negated): java.lang.Boolean)
      .`type`(`type`.unwrap)
      .dataId(ResourceId.unwrap(dataId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.Predicate.ReadOnly =
    zio.aws.waf.model.Predicate.wrap(buildAwsValue())
}
object Predicate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.Predicate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.Predicate =
      zio.aws.waf.model.Predicate(negated, `type`, dataId)
    def negated: Negated
    def `type`: zio.aws.waf.model.PredicateType
    def dataId: ResourceId
    def getNegated: ZIO[Any, Nothing, Negated] = ZIO.succeed(negated)
    def getType: ZIO[Any, Nothing, zio.aws.waf.model.PredicateType] =
      ZIO.succeed(`type`)
    def getDataId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(dataId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.Predicate
  ) extends zio.aws.waf.model.Predicate.ReadOnly {
    override val negated: Negated =
      zio.aws.waf.model.primitives.Negated(impl.negated())
    override val `type`: zio.aws.waf.model.PredicateType =
      zio.aws.waf.model.PredicateType.wrap(impl.`type`())
    override val dataId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.dataId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.Predicate
  ): zio.aws.waf.model.Predicate.ReadOnly = new Wrapper(impl)
}
