package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class RegexMatchTuple(
    fieldToMatch: zio.aws.waf.model.FieldToMatch,
    textTransformation: zio.aws.waf.model.TextTransformation,
    regexPatternSetId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.RegexMatchTuple = {
    import RegexMatchTuple.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RegexMatchTuple
      .builder()
      .fieldToMatch(fieldToMatch.buildAwsValue())
      .textTransformation(textTransformation.unwrap)
      .regexPatternSetId(ResourceId.unwrap(regexPatternSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.RegexMatchTuple.ReadOnly =
    zio.aws.waf.model.RegexMatchTuple.wrap(buildAwsValue())
}
object RegexMatchTuple {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.RegexMatchTuple
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.RegexMatchTuple =
      zio.aws.waf.model.RegexMatchTuple(
        fieldToMatch.asEditable,
        textTransformation,
        regexPatternSetId
      )
    def fieldToMatch: zio.aws.waf.model.FieldToMatch.ReadOnly
    def textTransformation: zio.aws.waf.model.TextTransformation
    def regexPatternSetId: ResourceId
    def getFieldToMatch
        : ZIO[Any, Nothing, zio.aws.waf.model.FieldToMatch.ReadOnly] =
      ZIO.succeed(fieldToMatch)
    def getTextTransformation
        : ZIO[Any, Nothing, zio.aws.waf.model.TextTransformation] =
      ZIO.succeed(textTransformation)
    def getRegexPatternSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexPatternSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RegexMatchTuple
  ) extends zio.aws.waf.model.RegexMatchTuple.ReadOnly {
    override val fieldToMatch: zio.aws.waf.model.FieldToMatch.ReadOnly =
      zio.aws.waf.model.FieldToMatch.wrap(impl.fieldToMatch())
    override val textTransformation: zio.aws.waf.model.TextTransformation =
      zio.aws.waf.model.TextTransformation.wrap(impl.textTransformation())
    override val regexPatternSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.regexPatternSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RegexMatchTuple
  ): zio.aws.waf.model.RegexMatchTuple.ReadOnly = new Wrapper(impl)
}
