package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.waf.model.primitives.{
  RegexPatternString,
  ResourceName,
  ResourceId
}
import scala.jdk.CollectionConverters.*
final case class RegexPatternSet(
    regexPatternSetId: ResourceId,
    name: Optional[ResourceName] = Optional.Absent,
    regexPatternStrings: Iterable[RegexPatternString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.RegexPatternSet = {
    import RegexPatternSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RegexPatternSet
      .builder()
      .regexPatternSetId(ResourceId.unwrap(regexPatternSetId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .regexPatternStrings(regexPatternStrings.map { item =>
        RegexPatternString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.RegexPatternSet.ReadOnly =
    zio.aws.waf.model.RegexPatternSet.wrap(buildAwsValue())
}
object RegexPatternSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.RegexPatternSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.RegexPatternSet =
      zio.aws.waf.model.RegexPatternSet(
        regexPatternSetId,
        name.map(value => value),
        regexPatternStrings
      )
    def regexPatternSetId: ResourceId
    def name: Optional[ResourceName]
    def regexPatternStrings: List[RegexPatternString]
    def getRegexPatternSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexPatternSetId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getRegexPatternStrings: ZIO[Any, Nothing, List[RegexPatternString]] =
      ZIO.succeed(regexPatternStrings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RegexPatternSet
  ) extends zio.aws.waf.model.RegexPatternSet.ReadOnly {
    override val regexPatternSetId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.regexPatternSetId())
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.waf.model.primitives.ResourceName(value))
    override val regexPatternStrings: List[RegexPatternString] = impl
      .regexPatternStrings()
      .asScala
      .map { item =>
        zio.aws.waf.model.primitives.RegexPatternString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RegexPatternSet
  ): zio.aws.waf.model.RegexPatternSet.ReadOnly = new Wrapper(impl)
}
