package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.RegexPatternString
import scala.jdk.CollectionConverters.*
final case class RegexPatternSetUpdate(
    action: zio.aws.waf.model.ChangeAction,
    regexPatternString: RegexPatternString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.RegexPatternSetUpdate = {
    import RegexPatternSetUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RegexPatternSetUpdate
      .builder()
      .action(action.unwrap)
      .regexPatternString(
        RegexPatternString.unwrap(regexPatternString): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.waf.model.RegexPatternSetUpdate.ReadOnly =
    zio.aws.waf.model.RegexPatternSetUpdate.wrap(buildAwsValue())
}
object RegexPatternSetUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.RegexPatternSetUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.RegexPatternSetUpdate =
      zio.aws.waf.model.RegexPatternSetUpdate(action, regexPatternString)
    def action: zio.aws.waf.model.ChangeAction
    def regexPatternString: RegexPatternString
    def getAction: ZIO[Any, Nothing, zio.aws.waf.model.ChangeAction] =
      ZIO.succeed(action)
    def getRegexPatternString: ZIO[Any, Nothing, RegexPatternString] =
      ZIO.succeed(regexPatternString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RegexPatternSetUpdate
  ) extends zio.aws.waf.model.RegexPatternSetUpdate.ReadOnly {
    override val action: zio.aws.waf.model.ChangeAction =
      zio.aws.waf.model.ChangeAction.wrap(impl.action())
    override val regexPatternString: RegexPatternString =
      zio.aws.waf.model.primitives.RegexPatternString(impl.regexPatternString())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RegexPatternSetUpdate
  ): zio.aws.waf.model.RegexPatternSetUpdate.ReadOnly = new Wrapper(impl)
}
