package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SqlInjectionMatchTuple(
    fieldToMatch: zio.aws.waf.model.FieldToMatch,
    textTransformation: zio.aws.waf.model.TextTransformation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.SqlInjectionMatchTuple = {
    import SqlInjectionMatchTuple.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.SqlInjectionMatchTuple
      .builder()
      .fieldToMatch(fieldToMatch.buildAwsValue())
      .textTransformation(textTransformation.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.SqlInjectionMatchTuple.ReadOnly =
    zio.aws.waf.model.SqlInjectionMatchTuple.wrap(buildAwsValue())
}
object SqlInjectionMatchTuple {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.SqlInjectionMatchTuple
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.SqlInjectionMatchTuple = zio.aws.waf.model
      .SqlInjectionMatchTuple(fieldToMatch.asEditable, textTransformation)
    def fieldToMatch: zio.aws.waf.model.FieldToMatch.ReadOnly
    def textTransformation: zio.aws.waf.model.TextTransformation
    def getFieldToMatch
        : ZIO[Any, Nothing, zio.aws.waf.model.FieldToMatch.ReadOnly] =
      ZIO.succeed(fieldToMatch)
    def getTextTransformation
        : ZIO[Any, Nothing, zio.aws.waf.model.TextTransformation] =
      ZIO.succeed(textTransformation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.SqlInjectionMatchTuple
  ) extends zio.aws.waf.model.SqlInjectionMatchTuple.ReadOnly {
    override val fieldToMatch: zio.aws.waf.model.FieldToMatch.ReadOnly =
      zio.aws.waf.model.FieldToMatch.wrap(impl.fieldToMatch())
    override val textTransformation: zio.aws.waf.model.TextTransformation =
      zio.aws.waf.model.TextTransformation.wrap(impl.textTransformation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.SqlInjectionMatchTuple
  ): zio.aws.waf.model.SqlInjectionMatchTuple.ReadOnly = new Wrapper(impl)
}
