package zio.aws.waf.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.waf.model.primitives.{ChangeToken, ResourceId}
import scala.jdk.CollectionConverters.*
final case class UpdateRuleRequest(
    ruleId: ResourceId,
    changeToken: ChangeToken,
    updates: Iterable[zio.aws.waf.model.RuleUpdate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateRuleRequest = {
    import UpdateRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateRuleRequest
      .builder()
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.waf.model.UpdateRuleRequest.ReadOnly =
    zio.aws.waf.model.UpdateRuleRequest.wrap(buildAwsValue())
}
object UpdateRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.waf.model.UpdateRuleRequest =
      zio.aws.waf.model.UpdateRuleRequest(
        ruleId,
        changeToken,
        updates.map { item =>
          item.asEditable
        }
      )
    def ruleId: ResourceId
    def changeToken: ChangeToken
    def updates: List[zio.aws.waf.model.RuleUpdate.ReadOnly]
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
    def getUpdates
        : ZIO[Any, Nothing, List[zio.aws.waf.model.RuleUpdate.ReadOnly]] =
      ZIO.succeed(updates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateRuleRequest
  ) extends zio.aws.waf.model.UpdateRuleRequest.ReadOnly {
    override val ruleId: ResourceId =
      zio.aws.waf.model.primitives.ResourceId(impl.ruleId())
    override val changeToken: ChangeToken =
      zio.aws.waf.model.primitives.ChangeToken(impl.changeToken())
    override val updates: List[zio.aws.waf.model.RuleUpdate.ReadOnly] = impl
      .updates()
      .asScala
      .map { item =>
        zio.aws.waf.model.RuleUpdate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateRuleRequest
  ): zio.aws.waf.model.UpdateRuleRequest.ReadOnly = new Wrapper(impl)
}
