package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceName, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ByteMatchSetSummary(
    byteMatchSetId: ResourceId,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ByteMatchSetSummary = {
    import ByteMatchSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ByteMatchSetSummary
      .builder()
      .byteMatchSetId(ResourceId.unwrap(byteMatchSetId): java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.ByteMatchSetSummary.ReadOnly =
    zio.aws.wafregional.model.ByteMatchSetSummary.wrap(buildAwsValue())
}
object ByteMatchSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ByteMatchSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ByteMatchSetSummary =
      zio.aws.wafregional.model.ByteMatchSetSummary(byteMatchSetId, name)
    def byteMatchSetId: ResourceId
    def name: ResourceName
    def getByteMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(byteMatchSetId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ByteMatchSetSummary
  ) extends zio.aws.wafregional.model.ByteMatchSetSummary.ReadOnly {
    override val byteMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.byteMatchSetId())
    override val name: ResourceName =
      zio.aws.wafregional.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ByteMatchSetSummary
  ): zio.aws.wafregional.model.ByteMatchSetSummary.ReadOnly = new Wrapper(impl)
}
