package zio.aws.wafregional.model
import scala.jdk.CollectionConverters.*
sealed trait ChangeAction {
  def unwrap: software.amazon.awssdk.services.waf.model.ChangeAction
}
object ChangeAction {
  def wrap(
      value: software.amazon.awssdk.services.waf.model.ChangeAction
  ): zio.aws.wafregional.model.ChangeAction = value match {
    case software.amazon.awssdk.services.waf.model.ChangeAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.waf.model.ChangeAction.INSERT =>
      val r = INSERT
      r
    case software.amazon.awssdk.services.waf.model.ChangeAction.DELETE =>
      val r = DELETE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wafregional.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ChangeAction =
      software.amazon.awssdk.services.waf.model.ChangeAction.UNKNOWN_TO_SDK_VERSION
  }
  case object INSERT extends zio.aws.wafregional.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ChangeAction =
      software.amazon.awssdk.services.waf.model.ChangeAction.INSERT
  }
  case object DELETE extends zio.aws.wafregional.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ChangeAction =
      software.amazon.awssdk.services.waf.model.ChangeAction.DELETE
  }
}
