package zio.aws.wafregional.model
import scala.jdk.CollectionConverters.*
sealed trait ComparisonOperator {
  def unwrap: software.amazon.awssdk.services.waf.model.ComparisonOperator
}
object ComparisonOperator {
  def wrap(
      value: software.amazon.awssdk.services.waf.model.ComparisonOperator
  ): zio.aws.wafregional.model.ComparisonOperator = value match {
    case software.amazon.awssdk.services.waf.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.waf.model.ComparisonOperator.EQ =>
      val r = EQ
      r
    case software.amazon.awssdk.services.waf.model.ComparisonOperator.NE =>
      val r = NE
      r
    case software.amazon.awssdk.services.waf.model.ComparisonOperator.LE =>
      val r = LE
      r
    case software.amazon.awssdk.services.waf.model.ComparisonOperator.LT =>
      val r = LT
      r
    case software.amazon.awssdk.services.waf.model.ComparisonOperator.GE =>
      val r = GE
      r
    case software.amazon.awssdk.services.waf.model.ComparisonOperator.GT =>
      val r = GT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wafregional.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ComparisonOperator =
      software.amazon.awssdk.services.waf.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object EQ extends zio.aws.wafregional.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ComparisonOperator =
      software.amazon.awssdk.services.waf.model.ComparisonOperator.EQ
  }
  case object NE extends zio.aws.wafregional.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ComparisonOperator =
      software.amazon.awssdk.services.waf.model.ComparisonOperator.NE
  }
  case object LE extends zio.aws.wafregional.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ComparisonOperator =
      software.amazon.awssdk.services.waf.model.ComparisonOperator.LE
  }
  case object LT extends zio.aws.wafregional.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ComparisonOperator =
      software.amazon.awssdk.services.waf.model.ComparisonOperator.LT
  }
  case object GE extends zio.aws.wafregional.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ComparisonOperator =
      software.amazon.awssdk.services.waf.model.ComparisonOperator.GE
  }
  case object GT extends zio.aws.wafregional.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ComparisonOperator =
      software.amazon.awssdk.services.waf.model.ComparisonOperator.GT
  }
}
