package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSizeConstraintSetResponse(
    sizeConstraintSet: Optional[zio.aws.wafregional.model.SizeConstraintSet] =
      Optional.Absent,
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetResponse = {
    import CreateSizeConstraintSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetResponse
      .builder()
      .optionallyWith(sizeConstraintSet.map(value => value.buildAwsValue()))(
        _.sizeConstraintSet
      )
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.CreateSizeConstraintSetResponse.ReadOnly =
    zio.aws.wafregional.model.CreateSizeConstraintSetResponse
      .wrap(buildAwsValue())
}
object CreateSizeConstraintSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.CreateSizeConstraintSetResponse =
      zio.aws.wafregional.model.CreateSizeConstraintSetResponse(
        sizeConstraintSet.map(value => value.asEditable),
        changeToken.map(value => value)
      )
    def sizeConstraintSet
        : Optional[zio.aws.wafregional.model.SizeConstraintSet.ReadOnly]
    def changeToken: Optional[ChangeToken]
    def getSizeConstraintSet: ZIO[
      Any,
      AwsError,
      zio.aws.wafregional.model.SizeConstraintSet.ReadOnly
    ] = AwsError.unwrapOptionField("sizeConstraintSet", sizeConstraintSet)
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetResponse
  ) extends zio.aws.wafregional.model.CreateSizeConstraintSetResponse.ReadOnly {
    override val sizeConstraintSet
        : Optional[zio.aws.wafregional.model.SizeConstraintSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sizeConstraintSet())
        .map(value => zio.aws.wafregional.model.SizeConstraintSet.wrap(value))
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateSizeConstraintSetResponse
  ): zio.aws.wafregional.model.CreateSizeConstraintSetResponse.ReadOnly =
    new Wrapper(impl)
}
