package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{
  IgnoreUnsupportedType,
  S3BucketName,
  ResourceId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateWebAclMigrationStackRequest(
    webACLId: ResourceId,
    s3BucketName: S3BucketName,
    ignoreUnsupportedType: IgnoreUnsupportedType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateWebAclMigrationStackRequest = {
    import CreateWebAclMigrationStackRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateWebAclMigrationStackRequest
      .builder()
      .webACLId(ResourceId.unwrap(webACLId): java.lang.String)
      .s3BucketName(S3BucketName.unwrap(s3BucketName): java.lang.String)
      .ignoreUnsupportedType(
        IgnoreUnsupportedType.unwrap(ignoreUnsupportedType): java.lang.Boolean
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.CreateWebAclMigrationStackRequest.ReadOnly =
    zio.aws.wafregional.model.CreateWebAclMigrationStackRequest
      .wrap(buildAwsValue())
}
object CreateWebAclMigrationStackRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateWebAclMigrationStackRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafregional.model.CreateWebAclMigrationStackRequest =
      zio.aws.wafregional.model.CreateWebAclMigrationStackRequest(
        webACLId,
        s3BucketName,
        ignoreUnsupportedType
      )
    def webACLId: ResourceId
    def s3BucketName: S3BucketName
    def ignoreUnsupportedType: IgnoreUnsupportedType
    def getWebACLId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(webACLId)
    def getS3BucketName: ZIO[Any, Nothing, S3BucketName] =
      ZIO.succeed(s3BucketName)
    def getIgnoreUnsupportedType: ZIO[Any, Nothing, IgnoreUnsupportedType] =
      ZIO.succeed(ignoreUnsupportedType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateWebAclMigrationStackRequest
  ) extends zio.aws.wafregional.model.CreateWebAclMigrationStackRequest.ReadOnly {
    override val webACLId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.webACLId())
    override val s3BucketName: S3BucketName =
      zio.aws.wafregional.model.primitives.S3BucketName(impl.s3BucketName())
    override val ignoreUnsupportedType: IgnoreUnsupportedType =
      zio.aws.wafregional.model.primitives
        .IgnoreUnsupportedType(impl.ignoreUnsupportedType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateWebAclMigrationStackRequest
  ): zio.aws.wafregional.model.CreateWebAclMigrationStackRequest.ReadOnly =
    new Wrapper(impl)
}
