package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ChangeToken, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteIpSetRequest(
    ipSetId: ResourceId,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteIpSetRequest = {
    import DeleteIpSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteIpSetRequest
      .builder()
      .ipSetId(ResourceId.unwrap(ipSetId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.DeleteIpSetRequest.ReadOnly =
    zio.aws.wafregional.model.DeleteIpSetRequest.wrap(buildAwsValue())
}
object DeleteIpSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteIpSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.DeleteIpSetRequest =
      zio.aws.wafregional.model.DeleteIpSetRequest(ipSetId, changeToken)
    def ipSetId: ResourceId
    def changeToken: ChangeToken
    def getIpSetId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ipSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteIpSetRequest
  ) extends zio.aws.wafregional.model.DeleteIpSetRequest.ReadOnly {
    override val ipSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.ipSetId())
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteIpSetRequest
  ): zio.aws.wafregional.model.DeleteIpSetRequest.ReadOnly = new Wrapper(impl)
}
