package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ChangeToken, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteRegexMatchSetRequest(
    regexMatchSetId: ResourceId,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteRegexMatchSetRequest = {
    import DeleteRegexMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteRegexMatchSetRequest
      .builder()
      .regexMatchSetId(ResourceId.unwrap(regexMatchSetId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.DeleteRegexMatchSetRequest.ReadOnly =
    zio.aws.wafregional.model.DeleteRegexMatchSetRequest.wrap(buildAwsValue())
}
object DeleteRegexMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteRegexMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.DeleteRegexMatchSetRequest =
      zio.aws.wafregional.model
        .DeleteRegexMatchSetRequest(regexMatchSetId, changeToken)
    def regexMatchSetId: ResourceId
    def changeToken: ChangeToken
    def getRegexMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexMatchSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteRegexMatchSetRequest
  ) extends zio.aws.wafregional.model.DeleteRegexMatchSetRequest.ReadOnly {
    override val regexMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.regexMatchSetId())
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteRegexMatchSetRequest
  ): zio.aws.wafregional.model.DeleteRegexMatchSetRequest.ReadOnly =
    new Wrapper(impl)
}
