package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ChangeToken, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteRegexPatternSetRequest(
    regexPatternSetId: ResourceId,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteRegexPatternSetRequest = {
    import DeleteRegexPatternSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteRegexPatternSetRequest
      .builder()
      .regexPatternSetId(ResourceId.unwrap(regexPatternSetId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.DeleteRegexPatternSetRequest.ReadOnly =
    zio.aws.wafregional.model.DeleteRegexPatternSetRequest.wrap(buildAwsValue())
}
object DeleteRegexPatternSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteRegexPatternSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.DeleteRegexPatternSetRequest =
      zio.aws.wafregional.model
        .DeleteRegexPatternSetRequest(regexPatternSetId, changeToken)
    def regexPatternSetId: ResourceId
    def changeToken: ChangeToken
    def getRegexPatternSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexPatternSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteRegexPatternSetRequest
  ) extends zio.aws.wafregional.model.DeleteRegexPatternSetRequest.ReadOnly {
    override val regexPatternSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.regexPatternSetId())
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteRegexPatternSetRequest
  ): zio.aws.wafregional.model.DeleteRegexPatternSetRequest.ReadOnly =
    new Wrapper(impl)
}
