package zio.aws.wafregional.model
import scala.jdk.CollectionConverters.*
sealed trait GeoMatchConstraintType {
  def unwrap: software.amazon.awssdk.services.waf.model.GeoMatchConstraintType
}
object GeoMatchConstraintType {
  def wrap(
      value: software.amazon.awssdk.services.waf.model.GeoMatchConstraintType
  ): zio.aws.wafregional.model.GeoMatchConstraintType = value match {
    case software.amazon.awssdk.services.waf.model.GeoMatchConstraintType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.waf.model.GeoMatchConstraintType.COUNTRY =>
      val r = Country
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wafregional.model.GeoMatchConstraintType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.GeoMatchConstraintType =
      software.amazon.awssdk.services.waf.model.GeoMatchConstraintType.UNKNOWN_TO_SDK_VERSION
  }
  case object Country extends zio.aws.wafregional.model.GeoMatchConstraintType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.GeoMatchConstraintType =
      software.amazon.awssdk.services.waf.model.GeoMatchConstraintType.COUNTRY
  }
}
