package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.PolicyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetPermissionPolicyResponse(
    policy: Optional[PolicyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetPermissionPolicyResponse = {
    import GetPermissionPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetPermissionPolicyResponse
      .builder()
      .optionallyWith(
        policy.map(value => PolicyString.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.GetPermissionPolicyResponse.ReadOnly =
    zio.aws.wafregional.model.GetPermissionPolicyResponse.wrap(buildAwsValue())
}
object GetPermissionPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetPermissionPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetPermissionPolicyResponse =
      zio.aws.wafregional.model
        .GetPermissionPolicyResponse(policy.map(value => value))
    def policy: Optional[PolicyString]
    def getPolicy: ZIO[Any, AwsError, PolicyString] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetPermissionPolicyResponse
  ) extends zio.aws.wafregional.model.GetPermissionPolicyResponse.ReadOnly {
    override val policy: Optional[PolicyString] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.wafregional.model.primitives.PolicyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetPermissionPolicyResponse
  ): zio.aws.wafregional.model.GetPermissionPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
