package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{
  GetSampledRequestsMaxItems,
  ResourceId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSampledRequestsRequest(
    webAclId: ResourceId,
    ruleId: ResourceId,
    timeWindow: zio.aws.wafregional.model.TimeWindow,
    maxItems: GetSampledRequestsMaxItems
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetSampledRequestsRequest = {
    import GetSampledRequestsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetSampledRequestsRequest
      .builder()
      .webAclId(ResourceId.unwrap(webAclId): java.lang.String)
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .timeWindow(timeWindow.buildAwsValue())
      .maxItems(GetSampledRequestsMaxItems.unwrap(maxItems): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetSampledRequestsRequest.ReadOnly =
    zio.aws.wafregional.model.GetSampledRequestsRequest.wrap(buildAwsValue())
}
object GetSampledRequestsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetSampledRequestsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetSampledRequestsRequest =
      zio.aws.wafregional.model.GetSampledRequestsRequest(
        webAclId,
        ruleId,
        timeWindow.asEditable,
        maxItems
      )
    def webAclId: ResourceId
    def ruleId: ResourceId
    def timeWindow: zio.aws.wafregional.model.TimeWindow.ReadOnly
    def maxItems: GetSampledRequestsMaxItems
    def getWebAclId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(webAclId)
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
    def getTimeWindow
        : ZIO[Any, Nothing, zio.aws.wafregional.model.TimeWindow.ReadOnly] =
      ZIO.succeed(timeWindow)
    def getMaxItems: ZIO[Any, Nothing, GetSampledRequestsMaxItems] =
      ZIO.succeed(maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetSampledRequestsRequest
  ) extends zio.aws.wafregional.model.GetSampledRequestsRequest.ReadOnly {
    override val webAclId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.webAclId())
    override val ruleId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.ruleId())
    override val timeWindow: zio.aws.wafregional.model.TimeWindow.ReadOnly =
      zio.aws.wafregional.model.TimeWindow.wrap(impl.timeWindow())
    override val maxItems: GetSampledRequestsMaxItems =
      zio.aws.wafregional.model.primitives
        .GetSampledRequestsMaxItems(impl.maxItems())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetSampledRequestsRequest
  ): zio.aws.wafregional.model.GetSampledRequestsRequest.ReadOnly = new Wrapper(
    impl
  )
}
