package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSizeConstraintSetRequest(sizeConstraintSetId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetSizeConstraintSetRequest = {
    import GetSizeConstraintSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetSizeConstraintSetRequest
      .builder()
      .sizeConstraintSetId(
        ResourceId.unwrap(sizeConstraintSetId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.GetSizeConstraintSetRequest.ReadOnly =
    zio.aws.wafregional.model.GetSizeConstraintSetRequest.wrap(buildAwsValue())
}
object GetSizeConstraintSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetSizeConstraintSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetSizeConstraintSetRequest =
      zio.aws.wafregional.model.GetSizeConstraintSetRequest(sizeConstraintSetId)
    def sizeConstraintSetId: ResourceId
    def getSizeConstraintSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sizeConstraintSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetSizeConstraintSetRequest
  ) extends zio.aws.wafregional.model.GetSizeConstraintSetRequest.ReadOnly {
    override val sizeConstraintSetId: ResourceId =
      zio.aws.wafregional.model.primitives
        .ResourceId(impl.sizeConstraintSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetSizeConstraintSetRequest
  ): zio.aws.wafregional.model.GetSizeConstraintSetRequest.ReadOnly =
    new Wrapper(impl)
}
