package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSqlInjectionMatchSetRequest(
    sqlInjectionMatchSetId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetRequest = {
    import GetSqlInjectionMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetRequest
      .builder()
      .sqlInjectionMatchSetId(
        ResourceId.unwrap(sqlInjectionMatchSetId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.GetSqlInjectionMatchSetRequest.ReadOnly =
    zio.aws.wafregional.model.GetSqlInjectionMatchSetRequest
      .wrap(buildAwsValue())
}
object GetSqlInjectionMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetSqlInjectionMatchSetRequest =
      zio.aws.wafregional.model
        .GetSqlInjectionMatchSetRequest(sqlInjectionMatchSetId)
    def sqlInjectionMatchSetId: ResourceId
    def getSqlInjectionMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sqlInjectionMatchSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetRequest
  ) extends zio.aws.wafregional.model.GetSqlInjectionMatchSetRequest.ReadOnly {
    override val sqlInjectionMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives
        .ResourceId(impl.sqlInjectionMatchSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetRequest
  ): zio.aws.wafregional.model.GetSqlInjectionMatchSetRequest.ReadOnly =
    new Wrapper(impl)
}
