package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetSqlInjectionMatchSetResponse(
    sqlInjectionMatchSet: Optional[
      zio.aws.wafregional.model.SqlInjectionMatchSet
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetResponse = {
    import GetSqlInjectionMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetResponse
      .builder()
      .optionallyWith(sqlInjectionMatchSet.map(value => value.buildAwsValue()))(
        _.sqlInjectionMatchSet
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.GetSqlInjectionMatchSetResponse.ReadOnly =
    zio.aws.wafregional.model.GetSqlInjectionMatchSetResponse
      .wrap(buildAwsValue())
}
object GetSqlInjectionMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetSqlInjectionMatchSetResponse =
      zio.aws.wafregional.model.GetSqlInjectionMatchSetResponse(
        sqlInjectionMatchSet.map(value => value.asEditable)
      )
    def sqlInjectionMatchSet
        : Optional[zio.aws.wafregional.model.SqlInjectionMatchSet.ReadOnly]
    def getSqlInjectionMatchSet: ZIO[
      Any,
      AwsError,
      zio.aws.wafregional.model.SqlInjectionMatchSet.ReadOnly
    ] = AwsError.unwrapOptionField("sqlInjectionMatchSet", sqlInjectionMatchSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetResponse
  ) extends zio.aws.wafregional.model.GetSqlInjectionMatchSetResponse.ReadOnly {
    override val sqlInjectionMatchSet
        : Optional[zio.aws.wafregional.model.SqlInjectionMatchSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sqlInjectionMatchSet())
        .map(value =>
          zio.aws.wafregional.model.SqlInjectionMatchSet.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetSqlInjectionMatchSetResponse
  ): zio.aws.wafregional.model.GetSqlInjectionMatchSetResponse.ReadOnly =
    new Wrapper(impl)
}
