package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetWebAclForResourceRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetWebAclForResourceRequest = {
    import GetWebAclForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetWebAclForResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.GetWebAclForResourceRequest.ReadOnly =
    zio.aws.wafregional.model.GetWebAclForResourceRequest.wrap(buildAwsValue())
}
object GetWebAclForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetWebAclForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetWebAclForResourceRequest =
      zio.aws.wafregional.model.GetWebAclForResourceRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetWebAclForResourceRequest
  ) extends zio.aws.wafregional.model.GetWebAclForResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.wafregional.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetWebAclForResourceRequest
  ): zio.aws.wafregional.model.GetWebAclForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
