package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetXssMatchSetResponse(
    xssMatchSet: Optional[zio.aws.wafregional.model.XssMatchSet] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse = {
    import GetXssMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse
      .builder()
      .optionallyWith(xssMatchSet.map(value => value.buildAwsValue()))(
        _.xssMatchSet
      )
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetXssMatchSetResponse.ReadOnly =
    zio.aws.wafregional.model.GetXssMatchSetResponse.wrap(buildAwsValue())
}
object GetXssMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetXssMatchSetResponse =
      zio.aws.wafregional.model
        .GetXssMatchSetResponse(xssMatchSet.map(value => value.asEditable))
    def xssMatchSet: Optional[zio.aws.wafregional.model.XssMatchSet.ReadOnly]
    def getXssMatchSet
        : ZIO[Any, AwsError, zio.aws.wafregional.model.XssMatchSet.ReadOnly] =
      AwsError.unwrapOptionField("xssMatchSet", xssMatchSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse
  ) extends zio.aws.wafregional.model.GetXssMatchSetResponse.ReadOnly {
    override val xssMatchSet
        : Optional[zio.aws.wafregional.model.XssMatchSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.xssMatchSet())
        .map(value => zio.aws.wafregional.model.XssMatchSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetXssMatchSetResponse
  ): zio.aws.wafregional.model.GetXssMatchSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
