package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{HeaderValue, HeaderName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HTTPHeader(
    name: Optional[HeaderName] = Optional.Absent,
    value: Optional[HeaderValue] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.HTTPHeader = {
    import HTTPHeader.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.HTTPHeader
      .builder()
      .optionallyWith(
        name.map(value => HeaderName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        value.map(value => HeaderValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.HTTPHeader.ReadOnly =
    zio.aws.wafregional.model.HTTPHeader.wrap(buildAwsValue())
}
object HTTPHeader {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.HTTPHeader] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.HTTPHeader =
      zio.aws.wafregional.model
        .HTTPHeader(name.map(value => value), value.map(value => value))
    def name: Optional[HeaderName]
    def value: Optional[HeaderValue]
    def getName: ZIO[Any, AwsError, HeaderName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, HeaderValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.HTTPHeader
  ) extends zio.aws.wafregional.model.HTTPHeader.ReadOnly {
    override val name: Optional[HeaderName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.wafregional.model.primitives.HeaderName(value))
    override val value: Optional[HeaderValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.wafregional.model.primitives.HeaderValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.HTTPHeader
  ): zio.aws.wafregional.model.HTTPHeader.ReadOnly = new Wrapper(impl)
}
