package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceName, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class IPSetSummary(ipSetId: ResourceId, name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.IPSetSummary = {
    import IPSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.IPSetSummary
      .builder()
      .ipSetId(ResourceId.unwrap(ipSetId): java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.IPSetSummary.ReadOnly =
    zio.aws.wafregional.model.IPSetSummary.wrap(buildAwsValue())
}
object IPSetSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.IPSetSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.IPSetSummary =
      zio.aws.wafregional.model.IPSetSummary(ipSetId, name)
    def ipSetId: ResourceId
    def name: ResourceName
    def getIpSetId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ipSetId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.IPSetSummary
  ) extends zio.aws.wafregional.model.IPSetSummary.ReadOnly {
    override val ipSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.ipSetId())
    override val name: ResourceName =
      zio.aws.wafregional.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.IPSetSummary
  ): zio.aws.wafregional.model.IPSetSummary.ReadOnly = new Wrapper(impl)
}
