package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.NextMarker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListLoggingConfigurationsResponse(
    loggingConfigurations: Optional[
      Iterable[zio.aws.wafregional.model.LoggingConfiguration]
    ] = Optional.Absent,
    nextMarker: Optional[NextMarker] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListLoggingConfigurationsResponse = {
    import ListLoggingConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListLoggingConfigurationsResponse
      .builder()
      .optionallyWith(
        loggingConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.loggingConfigurations)
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.ListLoggingConfigurationsResponse.ReadOnly =
    zio.aws.wafregional.model.ListLoggingConfigurationsResponse
      .wrap(buildAwsValue())
}
object ListLoggingConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListLoggingConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafregional.model.ListLoggingConfigurationsResponse =
      zio.aws.wafregional.model.ListLoggingConfigurationsResponse(
        loggingConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextMarker.map(value => value)
      )
    def loggingConfigurations: Optional[
      List[zio.aws.wafregional.model.LoggingConfiguration.ReadOnly]
    ]
    def nextMarker: Optional[NextMarker]
    def getLoggingConfigurations: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.LoggingConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("loggingConfigurations", loggingConfigurations)
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListLoggingConfigurationsResponse
  ) extends zio.aws.wafregional.model.ListLoggingConfigurationsResponse.ReadOnly {
    override val loggingConfigurations: Optional[
      List[zio.aws.wafregional.model.LoggingConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafregional.model.LoggingConfiguration.wrap(item)
        }.toList
      )
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListLoggingConfigurationsResponse
  ): zio.aws.wafregional.model.ListLoggingConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
