package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.NextMarker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListXssMatchSetsResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    xssMatchSets: Optional[
      Iterable[zio.aws.wafregional.model.XssMatchSetSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListXssMatchSetsResponse = {
    import ListXssMatchSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListXssMatchSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        xssMatchSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.xssMatchSets)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.ListXssMatchSetsResponse.ReadOnly =
    zio.aws.wafregional.model.ListXssMatchSetsResponse.wrap(buildAwsValue())
}
object ListXssMatchSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListXssMatchSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ListXssMatchSetsResponse =
      zio.aws.wafregional.model.ListXssMatchSetsResponse(
        nextMarker.map(value => value),
        xssMatchSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[NextMarker]
    def xssMatchSets
        : Optional[List[zio.aws.wafregional.model.XssMatchSetSummary.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getXssMatchSets: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.XssMatchSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("xssMatchSets", xssMatchSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListXssMatchSetsResponse
  ) extends zio.aws.wafregional.model.ListXssMatchSetsResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
    override val xssMatchSets: Optional[
      List[zio.aws.wafregional.model.XssMatchSetSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.xssMatchSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafregional.model.XssMatchSetSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListXssMatchSetsResponse
  ): zio.aws.wafregional.model.ListXssMatchSetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
