package zio.aws.wafregional.model
import scala.jdk.CollectionConverters.*
sealed trait PredicateType {
  def unwrap: software.amazon.awssdk.services.waf.model.PredicateType
}
object PredicateType {
  def wrap(
      value: software.amazon.awssdk.services.waf.model.PredicateType
  ): zio.aws.wafregional.model.PredicateType = value match {
    case software.amazon.awssdk.services.waf.model.PredicateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.waf.model.PredicateType.IP_MATCH =>
      val r = IPMatch
      r
    case software.amazon.awssdk.services.waf.model.PredicateType.BYTE_MATCH =>
      val r = ByteMatch
      r
    case software.amazon.awssdk.services.waf.model.PredicateType.SQL_INJECTION_MATCH =>
      val r = SqlInjectionMatch
      r
    case software.amazon.awssdk.services.waf.model.PredicateType.GEO_MATCH =>
      val r = GeoMatch
      r
    case software.amazon.awssdk.services.waf.model.PredicateType.SIZE_CONSTRAINT =>
      val r = SizeConstraint
      r
    case software.amazon.awssdk.services.waf.model.PredicateType.XSS_MATCH =>
      val r = XssMatch
      r
    case software.amazon.awssdk.services.waf.model.PredicateType.REGEX_MATCH =>
      val r = RegexMatch
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wafregional.model.PredicateType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.PredicateType =
      software.amazon.awssdk.services.waf.model.PredicateType.UNKNOWN_TO_SDK_VERSION
  }
  case object IPMatch extends zio.aws.wafregional.model.PredicateType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.PredicateType =
      software.amazon.awssdk.services.waf.model.PredicateType.IP_MATCH
  }
  case object ByteMatch extends zio.aws.wafregional.model.PredicateType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.PredicateType =
      software.amazon.awssdk.services.waf.model.PredicateType.BYTE_MATCH
  }
  case object SqlInjectionMatch
      extends zio.aws.wafregional.model.PredicateType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.PredicateType =
      software.amazon.awssdk.services.waf.model.PredicateType.SQL_INJECTION_MATCH
  }
  case object GeoMatch extends zio.aws.wafregional.model.PredicateType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.PredicateType =
      software.amazon.awssdk.services.waf.model.PredicateType.GEO_MATCH
  }
  case object SizeConstraint extends zio.aws.wafregional.model.PredicateType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.PredicateType =
      software.amazon.awssdk.services.waf.model.PredicateType.SIZE_CONSTRAINT
  }
  case object XssMatch extends zio.aws.wafregional.model.PredicateType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.PredicateType =
      software.amazon.awssdk.services.waf.model.PredicateType.XSS_MATCH
  }
  case object RegexMatch extends zio.aws.wafregional.model.PredicateType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.PredicateType =
      software.amazon.awssdk.services.waf.model.PredicateType.REGEX_MATCH
  }
}
