package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegexMatchSetUpdate(
    action: zio.aws.wafregional.model.ChangeAction,
    regexMatchTuple: zio.aws.wafregional.model.RegexMatchTuple
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.RegexMatchSetUpdate = {
    import RegexMatchSetUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RegexMatchSetUpdate
      .builder()
      .action(action.unwrap)
      .regexMatchTuple(regexMatchTuple.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.RegexMatchSetUpdate.ReadOnly =
    zio.aws.wafregional.model.RegexMatchSetUpdate.wrap(buildAwsValue())
}
object RegexMatchSetUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.RegexMatchSetUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.RegexMatchSetUpdate =
      zio.aws.wafregional.model
        .RegexMatchSetUpdate(action, regexMatchTuple.asEditable)
    def action: zio.aws.wafregional.model.ChangeAction
    def regexMatchTuple: zio.aws.wafregional.model.RegexMatchTuple.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.wafregional.model.ChangeAction] =
      ZIO.succeed(action)
    def getRegexMatchTuple: ZIO[
      Any,
      Nothing,
      zio.aws.wafregional.model.RegexMatchTuple.ReadOnly
    ] = ZIO.succeed(regexMatchTuple)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RegexMatchSetUpdate
  ) extends zio.aws.wafregional.model.RegexMatchSetUpdate.ReadOnly {
    override val action: zio.aws.wafregional.model.ChangeAction =
      zio.aws.wafregional.model.ChangeAction.wrap(impl.action())
    override val regexMatchTuple
        : zio.aws.wafregional.model.RegexMatchTuple.ReadOnly =
      zio.aws.wafregional.model.RegexMatchTuple.wrap(impl.regexMatchTuple())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RegexMatchSetUpdate
  ): zio.aws.wafregional.model.RegexMatchSetUpdate.ReadOnly = new Wrapper(impl)
}
