package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceName, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SizeConstraintSetSummary(
    sizeConstraintSetId: ResourceId,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.SizeConstraintSetSummary = {
    import SizeConstraintSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.SizeConstraintSetSummary
      .builder()
      .sizeConstraintSetId(
        ResourceId.unwrap(sizeConstraintSetId): java.lang.String
      )
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.SizeConstraintSetSummary.ReadOnly =
    zio.aws.wafregional.model.SizeConstraintSetSummary.wrap(buildAwsValue())
}
object SizeConstraintSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.SizeConstraintSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.SizeConstraintSetSummary =
      zio.aws.wafregional.model
        .SizeConstraintSetSummary(sizeConstraintSetId, name)
    def sizeConstraintSetId: ResourceId
    def name: ResourceName
    def getSizeConstraintSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sizeConstraintSetId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.SizeConstraintSetSummary
  ) extends zio.aws.wafregional.model.SizeConstraintSetSummary.ReadOnly {
    override val sizeConstraintSetId: ResourceId =
      zio.aws.wafregional.model.primitives
        .ResourceId(impl.sizeConstraintSetId())
    override val name: ResourceName =
      zio.aws.wafregional.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.SizeConstraintSetSummary
  ): zio.aws.wafregional.model.SizeConstraintSetSummary.ReadOnly = new Wrapper(
    impl
  )
}
