package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ChangeToken, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateRegexPatternSetRequest(
    regexPatternSetId: ResourceId,
    updates: Iterable[zio.aws.wafregional.model.RegexPatternSetUpdate],
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateRegexPatternSetRequest = {
    import UpdateRegexPatternSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateRegexPatternSetRequest
      .builder()
      .regexPatternSetId(ResourceId.unwrap(regexPatternSetId): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.UpdateRegexPatternSetRequest.ReadOnly =
    zio.aws.wafregional.model.UpdateRegexPatternSetRequest.wrap(buildAwsValue())
}
object UpdateRegexPatternSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateRegexPatternSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.UpdateRegexPatternSetRequest =
      zio.aws.wafregional.model.UpdateRegexPatternSetRequest(
        regexPatternSetId,
        updates.map { item =>
          item.asEditable
        },
        changeToken
      )
    def regexPatternSetId: ResourceId
    def updates: List[zio.aws.wafregional.model.RegexPatternSetUpdate.ReadOnly]
    def changeToken: ChangeToken
    def getRegexPatternSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexPatternSetId)
    def getUpdates: ZIO[Any, Nothing, List[
      zio.aws.wafregional.model.RegexPatternSetUpdate.ReadOnly
    ]] = ZIO.succeed(updates)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateRegexPatternSetRequest
  ) extends zio.aws.wafregional.model.UpdateRegexPatternSetRequest.ReadOnly {
    override val regexPatternSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.regexPatternSetId())
    override val updates
        : List[zio.aws.wafregional.model.RegexPatternSetUpdate.ReadOnly] = impl
      .updates()
      .asScala
      .map { item =>
        zio.aws.wafregional.model.RegexPatternSetUpdate.wrap(item)
      }
      .toList
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateRegexPatternSetRequest
  ): zio.aws.wafregional.model.UpdateRegexPatternSetRequest.ReadOnly =
    new Wrapper(impl)
}
