package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ChangeToken, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateSqlInjectionMatchSetRequest(
    sqlInjectionMatchSetId: ResourceId,
    changeToken: ChangeToken,
    updates: Iterable[zio.aws.wafregional.model.SqlInjectionMatchSetUpdate]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetRequest = {
    import UpdateSqlInjectionMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetRequest
      .builder()
      .sqlInjectionMatchSetId(
        ResourceId.unwrap(sqlInjectionMatchSetId): java.lang.String
      )
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.UpdateSqlInjectionMatchSetRequest.ReadOnly =
    zio.aws.wafregional.model.UpdateSqlInjectionMatchSetRequest
      .wrap(buildAwsValue())
}
object UpdateSqlInjectionMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafregional.model.UpdateSqlInjectionMatchSetRequest =
      zio.aws.wafregional.model.UpdateSqlInjectionMatchSetRequest(
        sqlInjectionMatchSetId,
        changeToken,
        updates.map { item =>
          item.asEditable
        }
      )
    def sqlInjectionMatchSetId: ResourceId
    def changeToken: ChangeToken
    def updates
        : List[zio.aws.wafregional.model.SqlInjectionMatchSetUpdate.ReadOnly]
    def getSqlInjectionMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sqlInjectionMatchSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
    def getUpdates: ZIO[Any, Nothing, List[
      zio.aws.wafregional.model.SqlInjectionMatchSetUpdate.ReadOnly
    ]] = ZIO.succeed(updates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetRequest
  ) extends zio.aws.wafregional.model.UpdateSqlInjectionMatchSetRequest.ReadOnly {
    override val sqlInjectionMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives
        .ResourceId(impl.sqlInjectionMatchSetId())
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
    override val updates
        : List[zio.aws.wafregional.model.SqlInjectionMatchSetUpdate.ReadOnly] =
      impl
        .updates()
        .asScala
        .map { item =>
          zio.aws.wafregional.model.SqlInjectionMatchSetUpdate.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetRequest
  ): zio.aws.wafregional.model.UpdateSqlInjectionMatchSetRequest.ReadOnly =
    new Wrapper(impl)
}
