package zio.aws.wafv2.model
import zio.aws.wafv2.model.primitives.{
  APIKeyVersion,
  Timestamp,
  APIKey,
  TokenDomain
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class APIKeySummary(
    tokenDomains: Optional[Iterable[TokenDomain]] = Optional.Absent,
    apiKey: Optional[APIKey] = Optional.Absent,
    creationTimestamp: Optional[Timestamp] = Optional.Absent,
    version: Optional[APIKeyVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.APIKeySummary = {
    import APIKeySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.APIKeySummary
      .builder()
      .optionallyWith(
        tokenDomains.map(value =>
          value.map { item =>
            TokenDomain.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tokenDomains)
      .optionallyWith(
        apiKey.map(value => APIKey.unwrap(value): java.lang.String)
      )(_.apiKey)
      .optionallyWith(
        creationTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTimestamp)
      .optionallyWith(
        version.map(value => APIKeyVersion.unwrap(value): Integer)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.APIKeySummary.ReadOnly =
    zio.aws.wafv2.model.APIKeySummary.wrap(buildAwsValue())
}
object APIKeySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.APIKeySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.APIKeySummary =
      zio.aws.wafv2.model.APIKeySummary(
        tokenDomains.map(value => value),
        apiKey.map(value => value),
        creationTimestamp.map(value => value),
        version.map(value => value)
      )
    def tokenDomains: Optional[List[TokenDomain]]
    def apiKey: Optional[APIKey]
    def creationTimestamp: Optional[Timestamp]
    def version: Optional[APIKeyVersion]
    def getTokenDomains: ZIO[Any, AwsError, List[TokenDomain]] =
      AwsError.unwrapOptionField("tokenDomains", tokenDomains)
    def getApiKey: ZIO[Any, AwsError, APIKey] =
      AwsError.unwrapOptionField("apiKey", apiKey)
    def getCreationTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTimestamp", creationTimestamp)
    def getVersion: ZIO[Any, AwsError, APIKeyVersion] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.APIKeySummary
  ) extends zio.aws.wafv2.model.APIKeySummary.ReadOnly {
    override val tokenDomains: Optional[List[TokenDomain]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tokenDomains())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.primitives.TokenDomain(item)
          }.toList
        )
    override val apiKey: Optional[APIKey] = zio.aws.core.internal
      .optionalFromNullable(impl.apiKey())
      .map(value => zio.aws.wafv2.model.primitives.APIKey(value))
    override val creationTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTimestamp())
      .map(value => zio.aws.wafv2.model.primitives.Timestamp(value))
    override val version: Optional[APIKeyVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.wafv2.model.primitives.APIKeyVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.APIKeySummary
  ): zio.aws.wafv2.model.APIKeySummary.ReadOnly = new Wrapper(impl)
}
