package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{
  RegistrationPagePathString,
  CreationPathString
}
import scala.jdk.CollectionConverters.*
final case class AWSManagedRulesACFPRuleSet(
    creationPath: CreationPathString,
    registrationPagePath: RegistrationPagePathString,
    requestInspection: zio.aws.wafv2.model.RequestInspectionACFP,
    responseInspection: Optional[zio.aws.wafv2.model.ResponseInspection] =
      Optional.Absent,
    enableRegexInPath: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.AWSManagedRulesACFPRuleSet = {
    import AWSManagedRulesACFPRuleSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.AWSManagedRulesACFPRuleSet
      .builder()
      .creationPath(CreationPathString.unwrap(creationPath): java.lang.String)
      .registrationPagePath(
        RegistrationPagePathString.unwrap(
          registrationPagePath
        ): java.lang.String
      )
      .requestInspection(requestInspection.buildAwsValue())
      .optionallyWith(responseInspection.map(value => value.buildAwsValue()))(
        _.responseInspection
      )
      .optionallyWith(enableRegexInPath.map(value => value: java.lang.Boolean))(
        _.enableRegexInPath
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.AWSManagedRulesACFPRuleSet.ReadOnly =
    zio.aws.wafv2.model.AWSManagedRulesACFPRuleSet.wrap(buildAwsValue())
}
object AWSManagedRulesACFPRuleSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.AWSManagedRulesACFPRuleSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.AWSManagedRulesACFPRuleSet =
      zio.aws.wafv2.model.AWSManagedRulesACFPRuleSet(
        creationPath,
        registrationPagePath,
        requestInspection.asEditable,
        responseInspection.map(value => value.asEditable),
        enableRegexInPath.map(value => value)
      )
    def creationPath: CreationPathString
    def registrationPagePath: RegistrationPagePathString
    def requestInspection: zio.aws.wafv2.model.RequestInspectionACFP.ReadOnly
    def responseInspection
        : Optional[zio.aws.wafv2.model.ResponseInspection.ReadOnly]
    def enableRegexInPath: Optional[Boolean]
    def getCreationPath: ZIO[Any, Nothing, CreationPathString] =
      ZIO.succeed(creationPath)
    def getRegistrationPagePath: ZIO[Any, Nothing, RegistrationPagePathString] =
      ZIO.succeed(registrationPagePath)
    def getRequestInspection: ZIO[
      Any,
      Nothing,
      zio.aws.wafv2.model.RequestInspectionACFP.ReadOnly
    ] = ZIO.succeed(requestInspection)
    def getResponseInspection
        : ZIO[Any, AwsError, zio.aws.wafv2.model.ResponseInspection.ReadOnly] =
      AwsError.unwrapOptionField("responseInspection", responseInspection)
    def getEnableRegexInPath: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableRegexInPath", enableRegexInPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.AWSManagedRulesACFPRuleSet
  ) extends zio.aws.wafv2.model.AWSManagedRulesACFPRuleSet.ReadOnly {
    override val creationPath: CreationPathString =
      zio.aws.wafv2.model.primitives.CreationPathString(impl.creationPath())
    override val registrationPagePath: RegistrationPagePathString =
      zio.aws.wafv2.model.primitives
        .RegistrationPagePathString(impl.registrationPagePath())
    override val requestInspection
        : zio.aws.wafv2.model.RequestInspectionACFP.ReadOnly =
      zio.aws.wafv2.model.RequestInspectionACFP.wrap(impl.requestInspection())
    override val responseInspection
        : Optional[zio.aws.wafv2.model.ResponseInspection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.responseInspection())
        .map(value => zio.aws.wafv2.model.ResponseInspection.wrap(value))
    override val enableRegexInPath: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableRegexInPath())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.AWSManagedRulesACFPRuleSet
  ): zio.aws.wafv2.model.AWSManagedRulesACFPRuleSet.ReadOnly = new Wrapper(impl)
}
