package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AWSManagedRulesBotControlRuleSet(
    inspectionLevel: zio.aws.wafv2.model.InspectionLevel,
    enableMachineLearning: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.AWSManagedRulesBotControlRuleSet = {
    import AWSManagedRulesBotControlRuleSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.AWSManagedRulesBotControlRuleSet
      .builder()
      .inspectionLevel(inspectionLevel.unwrap)
      .optionallyWith(
        enableMachineLearning.map(value => value: java.lang.Boolean)
      )(_.enableMachineLearning)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.AWSManagedRulesBotControlRuleSet.ReadOnly =
    zio.aws.wafv2.model.AWSManagedRulesBotControlRuleSet.wrap(buildAwsValue())
}
object AWSManagedRulesBotControlRuleSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.AWSManagedRulesBotControlRuleSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.AWSManagedRulesBotControlRuleSet =
      zio.aws.wafv2.model.AWSManagedRulesBotControlRuleSet(
        inspectionLevel,
        enableMachineLearning.map(value => value)
      )
    def inspectionLevel: zio.aws.wafv2.model.InspectionLevel
    def enableMachineLearning: Optional[Boolean]
    def getInspectionLevel
        : ZIO[Any, Nothing, zio.aws.wafv2.model.InspectionLevel] =
      ZIO.succeed(inspectionLevel)
    def getEnableMachineLearning: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableMachineLearning", enableMachineLearning)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.AWSManagedRulesBotControlRuleSet
  ) extends zio.aws.wafv2.model.AWSManagedRulesBotControlRuleSet.ReadOnly {
    override val inspectionLevel: zio.aws.wafv2.model.InspectionLevel =
      zio.aws.wafv2.model.InspectionLevel.wrap(impl.inspectionLevel())
    override val enableMachineLearning: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableMachineLearning())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.AWSManagedRulesBotControlRuleSet
  ): zio.aws.wafv2.model.AWSManagedRulesBotControlRuleSet.ReadOnly =
    new Wrapper(impl)
}
