package zio.aws.wafv2.model
import scala.jdk.CollectionConverters.*
sealed trait AssociatedResourceType {
  def unwrap: software.amazon.awssdk.services.wafv2.model.AssociatedResourceType
}
object AssociatedResourceType {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.AssociatedResourceType
  ): zio.aws.wafv2.model.AssociatedResourceType = value match {
    case software.amazon.awssdk.services.wafv2.model.AssociatedResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.AssociatedResourceType.CLOUDFRONT =>
      val r = CLOUDFRONT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wafv2.model.AssociatedResourceType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.AssociatedResourceType =
      software.amazon.awssdk.services.wafv2.model.AssociatedResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object CLOUDFRONT extends zio.aws.wafv2.model.AssociatedResourceType {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.AssociatedResourceType =
      software.amazon.awssdk.services.wafv2.model.AssociatedResourceType.CLOUDFRONT
  }
}
