package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociationConfig(
    requestBody: Optional[Map[
      zio.aws.wafv2.model.AssociatedResourceType,
      zio.aws.wafv2.model.RequestBodyAssociatedResourceTypeConfig
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.AssociationConfig = {
    import AssociationConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.AssociationConfig
      .builder()
      .optionallyWith(
        requestBody.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.requestBodyWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.AssociationConfig.ReadOnly =
    zio.aws.wafv2.model.AssociationConfig.wrap(buildAwsValue())
}
object AssociationConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.AssociationConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.AssociationConfig =
      zio.aws.wafv2.model.AssociationConfig(
        requestBody.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def requestBody: Optional[Map[
      zio.aws.wafv2.model.AssociatedResourceType,
      zio.aws.wafv2.model.RequestBodyAssociatedResourceTypeConfig.ReadOnly
    ]]
    def getRequestBody: ZIO[Any, AwsError, Map[
      zio.aws.wafv2.model.AssociatedResourceType,
      zio.aws.wafv2.model.RequestBodyAssociatedResourceTypeConfig.ReadOnly
    ]] = AwsError.unwrapOptionField("requestBody", requestBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.AssociationConfig
  ) extends zio.aws.wafv2.model.AssociationConfig.ReadOnly {
    override val requestBody: Optional[Map[
      zio.aws.wafv2.model.AssociatedResourceType,
      zio.aws.wafv2.model.RequestBodyAssociatedResourceTypeConfig.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.requestBody())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wafv2.model.AssociatedResourceType.wrap(
              key
            ) -> zio.aws.wafv2.model.RequestBodyAssociatedResourceTypeConfig
              .wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.AssociationConfig
  ): zio.aws.wafv2.model.AssociationConfig.ReadOnly = new Wrapper(impl)
}
