package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BlockAction(
    customResponse: Optional[zio.aws.wafv2.model.CustomResponse] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.BlockAction = {
    import BlockAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.BlockAction
      .builder()
      .optionallyWith(customResponse.map(value => value.buildAwsValue()))(
        _.customResponse
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.BlockAction.ReadOnly =
    zio.aws.wafv2.model.BlockAction.wrap(buildAwsValue())
}
object BlockAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.BlockAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.BlockAction = zio.aws.wafv2.model
      .BlockAction(customResponse.map(value => value.asEditable))
    def customResponse: Optional[zio.aws.wafv2.model.CustomResponse.ReadOnly]
    def getCustomResponse
        : ZIO[Any, AwsError, zio.aws.wafv2.model.CustomResponse.ReadOnly] =
      AwsError.unwrapOptionField("customResponse", customResponse)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.BlockAction
  ) extends zio.aws.wafv2.model.BlockAction.ReadOnly {
    override val customResponse
        : Optional[zio.aws.wafv2.model.CustomResponse.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customResponse())
        .map(value => zio.aws.wafv2.model.CustomResponse.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.BlockAction
  ): zio.aws.wafv2.model.BlockAction.ReadOnly = new Wrapper(impl)
}
