package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Body(
    oversizeHandling: Optional[zio.aws.wafv2.model.OversizeHandling] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.Body = {
    import Body.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.Body
      .builder()
      .optionallyWith(oversizeHandling.map(value => value.unwrap))(
        _.oversizeHandling
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.Body.ReadOnly =
    zio.aws.wafv2.model.Body.wrap(buildAwsValue())
}
object Body {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.Body] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.Body =
      zio.aws.wafv2.model.Body(oversizeHandling.map(value => value))
    def oversizeHandling: Optional[zio.aws.wafv2.model.OversizeHandling]
    def getOversizeHandling
        : ZIO[Any, AwsError, zio.aws.wafv2.model.OversizeHandling] =
      AwsError.unwrapOptionField("oversizeHandling", oversizeHandling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.Body
  ) extends zio.aws.wafv2.model.Body.ReadOnly {
    override val oversizeHandling
        : Optional[zio.aws.wafv2.model.OversizeHandling] = zio.aws.core.internal
      .optionalFromNullable(impl.oversizeHandling())
      .map(value => zio.aws.wafv2.model.OversizeHandling.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.Body
  ): zio.aws.wafv2.model.Body.ReadOnly = new Wrapper(impl)
}
