package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ChallengeConfig(
    immunityTimeProperty: Optional[zio.aws.wafv2.model.ImmunityTimeProperty] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.ChallengeConfig = {
    import ChallengeConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.ChallengeConfig
      .builder()
      .optionallyWith(immunityTimeProperty.map(value => value.buildAwsValue()))(
        _.immunityTimeProperty
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.ChallengeConfig.ReadOnly =
    zio.aws.wafv2.model.ChallengeConfig.wrap(buildAwsValue())
}
object ChallengeConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.ChallengeConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.ChallengeConfig = zio.aws.wafv2.model
      .ChallengeConfig(immunityTimeProperty.map(value => value.asEditable))
    def immunityTimeProperty
        : Optional[zio.aws.wafv2.model.ImmunityTimeProperty.ReadOnly]
    def getImmunityTimeProperty: ZIO[
      Any,
      AwsError,
      zio.aws.wafv2.model.ImmunityTimeProperty.ReadOnly
    ] = AwsError.unwrapOptionField("immunityTimeProperty", immunityTimeProperty)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.ChallengeConfig
  ) extends zio.aws.wafv2.model.ChallengeConfig.ReadOnly {
    override val immunityTimeProperty
        : Optional[zio.aws.wafv2.model.ImmunityTimeProperty.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.immunityTimeProperty())
        .map(value => zio.aws.wafv2.model.ImmunityTimeProperty.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.ChallengeConfig
  ): zio.aws.wafv2.model.ChallengeConfig.ReadOnly = new Wrapper(impl)
}
