package zio.aws.wafv2.model
import scala.jdk.CollectionConverters.*
sealed trait ComparisonOperator {
  def unwrap: software.amazon.awssdk.services.wafv2.model.ComparisonOperator
}
object ComparisonOperator {
  def wrap(
      value: software.amazon.awssdk.services.wafv2.model.ComparisonOperator
  ): zio.aws.wafv2.model.ComparisonOperator = value match {
    case software.amazon.awssdk.services.wafv2.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.wafv2.model.ComparisonOperator.EQ =>
      val r = EQ
      r
    case software.amazon.awssdk.services.wafv2.model.ComparisonOperator.NE =>
      val r = NE
      r
    case software.amazon.awssdk.services.wafv2.model.ComparisonOperator.LE =>
      val r = LE
      r
    case software.amazon.awssdk.services.wafv2.model.ComparisonOperator.LT =>
      val r = LT
      r
    case software.amazon.awssdk.services.wafv2.model.ComparisonOperator.GE =>
      val r = GE
      r
    case software.amazon.awssdk.services.wafv2.model.ComparisonOperator.GT =>
      val r = GT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wafv2.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ComparisonOperator =
      software.amazon.awssdk.services.wafv2.model.ComparisonOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object EQ extends zio.aws.wafv2.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ComparisonOperator =
      software.amazon.awssdk.services.wafv2.model.ComparisonOperator.EQ
  }
  case object NE extends zio.aws.wafv2.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ComparisonOperator =
      software.amazon.awssdk.services.wafv2.model.ComparisonOperator.NE
  }
  case object LE extends zio.aws.wafv2.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ComparisonOperator =
      software.amazon.awssdk.services.wafv2.model.ComparisonOperator.LE
  }
  case object LT extends zio.aws.wafv2.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ComparisonOperator =
      software.amazon.awssdk.services.wafv2.model.ComparisonOperator.LT
  }
  case object GE extends zio.aws.wafv2.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ComparisonOperator =
      software.amazon.awssdk.services.wafv2.model.ComparisonOperator.GE
  }
  case object GT extends zio.aws.wafv2.model.ComparisonOperator {
    override def unwrap
        : software.amazon.awssdk.services.wafv2.model.ComparisonOperator =
      software.amazon.awssdk.services.wafv2.model.ComparisonOperator.GT
  }
}
