package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Cookies(
    matchPattern: zio.aws.wafv2.model.CookieMatchPattern,
    matchScope: zio.aws.wafv2.model.MapMatchScope,
    oversizeHandling: zio.aws.wafv2.model.OversizeHandling
) {
  def buildAwsValue(): software.amazon.awssdk.services.wafv2.model.Cookies = {
    import Cookies.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.Cookies
      .builder()
      .matchPattern(matchPattern.buildAwsValue())
      .matchScope(matchScope.unwrap)
      .oversizeHandling(oversizeHandling.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.Cookies.ReadOnly =
    zio.aws.wafv2.model.Cookies.wrap(buildAwsValue())
}
object Cookies {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.wafv2.model.Cookies] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.Cookies = zio.aws.wafv2.model
      .Cookies(matchPattern.asEditable, matchScope, oversizeHandling)
    def matchPattern: zio.aws.wafv2.model.CookieMatchPattern.ReadOnly
    def matchScope: zio.aws.wafv2.model.MapMatchScope
    def oversizeHandling: zio.aws.wafv2.model.OversizeHandling
    def getMatchPattern
        : ZIO[Any, Nothing, zio.aws.wafv2.model.CookieMatchPattern.ReadOnly] =
      ZIO.succeed(matchPattern)
    def getMatchScope: ZIO[Any, Nothing, zio.aws.wafv2.model.MapMatchScope] =
      ZIO.succeed(matchScope)
    def getOversizeHandling
        : ZIO[Any, Nothing, zio.aws.wafv2.model.OversizeHandling] =
      ZIO.succeed(oversizeHandling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.Cookies
  ) extends zio.aws.wafv2.model.Cookies.ReadOnly {
    override val matchPattern: zio.aws.wafv2.model.CookieMatchPattern.ReadOnly =
      zio.aws.wafv2.model.CookieMatchPattern.wrap(impl.matchPattern())
    override val matchScope: zio.aws.wafv2.model.MapMatchScope =
      zio.aws.wafv2.model.MapMatchScope.wrap(impl.matchScope())
    override val oversizeHandling: zio.aws.wafv2.model.OversizeHandling =
      zio.aws.wafv2.model.OversizeHandling.wrap(impl.oversizeHandling())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.Cookies
  ): zio.aws.wafv2.model.Cookies.ReadOnly = new Wrapper(impl)
}
