package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.APIKey
import scala.jdk.CollectionConverters.*
final case class CreateApiKeyResponse(
    apiKey: Optional[APIKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CreateApiKeyResponse = {
    import CreateApiKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CreateApiKeyResponse
      .builder()
      .optionallyWith(
        apiKey.map(value => APIKey.unwrap(value): java.lang.String)
      )(_.apiKey)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CreateApiKeyResponse.ReadOnly =
    zio.aws.wafv2.model.CreateApiKeyResponse.wrap(buildAwsValue())
}
object CreateApiKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CreateApiKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CreateApiKeyResponse =
      zio.aws.wafv2.model.CreateApiKeyResponse(apiKey.map(value => value))
    def apiKey: Optional[APIKey]
    def getApiKey: ZIO[Any, AwsError, APIKey] =
      AwsError.unwrapOptionField("apiKey", apiKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CreateApiKeyResponse
  ) extends zio.aws.wafv2.model.CreateApiKeyResponse.ReadOnly {
    override val apiKey: Optional[APIKey] = zio.aws.core.internal
      .optionalFromNullable(impl.apiKey())
      .map(value => zio.aws.wafv2.model.primitives.APIKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CreateApiKeyResponse
  ): zio.aws.wafv2.model.CreateApiKeyResponse.ReadOnly = new Wrapper(impl)
}
