package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.wafv2.model.primitives.{
  TokenDomain,
  EntityDescription,
  EntityName
}
import scala.jdk.CollectionConverters.*
final case class CreateWebAclRequest(
    name: EntityName,
    scope: zio.aws.wafv2.model.Scope,
    defaultAction: zio.aws.wafv2.model.DefaultAction,
    description: Optional[EntityDescription] = Optional.Absent,
    rules: Optional[Iterable[zio.aws.wafv2.model.Rule]] = Optional.Absent,
    visibilityConfig: zio.aws.wafv2.model.VisibilityConfig,
    tags: Optional[Iterable[zio.aws.wafv2.model.Tag]] = Optional.Absent,
    customResponseBodies: Optional[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody]
    ] = Optional.Absent,
    captchaConfig: Optional[zio.aws.wafv2.model.CaptchaConfig] =
      Optional.Absent,
    challengeConfig: Optional[zio.aws.wafv2.model.ChallengeConfig] =
      Optional.Absent,
    tokenDomains: Optional[Iterable[TokenDomain]] = Optional.Absent,
    associationConfig: Optional[zio.aws.wafv2.model.AssociationConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CreateWebAclRequest = {
    import CreateWebAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CreateWebAclRequest
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .scope(scope.unwrap)
      .defaultAction(defaultAction.buildAwsValue())
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .visibilityConfig(visibilityConfig.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        customResponseBodies.map(value =>
          value
            .map({ case (key, value) =>
              (EntityName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.customResponseBodies)
      .optionallyWith(captchaConfig.map(value => value.buildAwsValue()))(
        _.captchaConfig
      )
      .optionallyWith(challengeConfig.map(value => value.buildAwsValue()))(
        _.challengeConfig
      )
      .optionallyWith(
        tokenDomains.map(value =>
          value.map { item =>
            TokenDomain.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tokenDomains)
      .optionallyWith(associationConfig.map(value => value.buildAwsValue()))(
        _.associationConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CreateWebAclRequest.ReadOnly =
    zio.aws.wafv2.model.CreateWebAclRequest.wrap(buildAwsValue())
}
object CreateWebAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CreateWebAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CreateWebAclRequest =
      zio.aws.wafv2.model.CreateWebAclRequest(
        name,
        scope,
        defaultAction.asEditable,
        description.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        visibilityConfig.asEditable,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customResponseBodies.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        captchaConfig.map(value => value.asEditable),
        challengeConfig.map(value => value.asEditable),
        tokenDomains.map(value => value),
        associationConfig.map(value => value.asEditable)
      )
    def name: EntityName
    def scope: zio.aws.wafv2.model.Scope
    def defaultAction: zio.aws.wafv2.model.DefaultAction.ReadOnly
    def description: Optional[EntityDescription]
    def rules: Optional[List[zio.aws.wafv2.model.Rule.ReadOnly]]
    def visibilityConfig: zio.aws.wafv2.model.VisibilityConfig.ReadOnly
    def tags: Optional[List[zio.aws.wafv2.model.Tag.ReadOnly]]
    def customResponseBodies: Optional[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody.ReadOnly]
    ]
    def captchaConfig: Optional[zio.aws.wafv2.model.CaptchaConfig.ReadOnly]
    def challengeConfig: Optional[zio.aws.wafv2.model.ChallengeConfig.ReadOnly]
    def tokenDomains: Optional[List[TokenDomain]]
    def associationConfig
        : Optional[zio.aws.wafv2.model.AssociationConfig.ReadOnly]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getDefaultAction
        : ZIO[Any, Nothing, zio.aws.wafv2.model.DefaultAction.ReadOnly] =
      ZIO.succeed(defaultAction)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRules: ZIO[Any, AwsError, List[zio.aws.wafv2.model.Rule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getVisibilityConfig
        : ZIO[Any, Nothing, zio.aws.wafv2.model.VisibilityConfig.ReadOnly] =
      ZIO.succeed(visibilityConfig)
    def getTags: ZIO[Any, AwsError, List[zio.aws.wafv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getCustomResponseBodies: ZIO[Any, AwsError, Map[
      EntityName,
      zio.aws.wafv2.model.CustomResponseBody.ReadOnly
    ]] =
      AwsError.unwrapOptionField("customResponseBodies", customResponseBodies)
    def getCaptchaConfig
        : ZIO[Any, AwsError, zio.aws.wafv2.model.CaptchaConfig.ReadOnly] =
      AwsError.unwrapOptionField("captchaConfig", captchaConfig)
    def getChallengeConfig
        : ZIO[Any, AwsError, zio.aws.wafv2.model.ChallengeConfig.ReadOnly] =
      AwsError.unwrapOptionField("challengeConfig", challengeConfig)
    def getTokenDomains: ZIO[Any, AwsError, List[TokenDomain]] =
      AwsError.unwrapOptionField("tokenDomains", tokenDomains)
    def getAssociationConfig
        : ZIO[Any, AwsError, zio.aws.wafv2.model.AssociationConfig.ReadOnly] =
      AwsError.unwrapOptionField("associationConfig", associationConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CreateWebAclRequest
  ) extends zio.aws.wafv2.model.CreateWebAclRequest.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val defaultAction: zio.aws.wafv2.model.DefaultAction.ReadOnly =
      zio.aws.wafv2.model.DefaultAction.wrap(impl.defaultAction())
    override val description: Optional[EntityDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val rules: Optional[List[zio.aws.wafv2.model.Rule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.Rule.wrap(item)
          }.toList
        )
    override val visibilityConfig
        : zio.aws.wafv2.model.VisibilityConfig.ReadOnly =
      zio.aws.wafv2.model.VisibilityConfig.wrap(impl.visibilityConfig())
    override val tags: Optional[List[zio.aws.wafv2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.Tag.wrap(item)
          }.toList
        )
    override val customResponseBodies: Optional[
      Map[EntityName, zio.aws.wafv2.model.CustomResponseBody.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customResponseBodies())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.wafv2.model.primitives.EntityName(
              key
            ) -> zio.aws.wafv2.model.CustomResponseBody.wrap(value)
          })
          .toMap
      )
    override val captchaConfig
        : Optional[zio.aws.wafv2.model.CaptchaConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.captchaConfig())
        .map(value => zio.aws.wafv2.model.CaptchaConfig.wrap(value))
    override val challengeConfig
        : Optional[zio.aws.wafv2.model.ChallengeConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.challengeConfig())
        .map(value => zio.aws.wafv2.model.ChallengeConfig.wrap(value))
    override val tokenDomains: Optional[List[TokenDomain]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tokenDomains())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafv2.model.primitives.TokenDomain(item)
          }.toList
        )
    override val associationConfig
        : Optional[zio.aws.wafv2.model.AssociationConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associationConfig())
        .map(value => zio.aws.wafv2.model.AssociationConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CreateWebAclRequest
  ): zio.aws.wafv2.model.CreateWebAclRequest.ReadOnly = new Wrapper(impl)
}
