package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateWebAclResponse(
    summary: Optional[zio.aws.wafv2.model.WebACLSummary] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CreateWebAclResponse = {
    import CreateWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CreateWebAclResponse
      .builder()
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CreateWebAclResponse.ReadOnly =
    zio.aws.wafv2.model.CreateWebAclResponse.wrap(buildAwsValue())
}
object CreateWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CreateWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CreateWebAclResponse =
      zio.aws.wafv2.model
        .CreateWebAclResponse(summary.map(value => value.asEditable))
    def summary: Optional[zio.aws.wafv2.model.WebACLSummary.ReadOnly]
    def getSummary
        : ZIO[Any, AwsError, zio.aws.wafv2.model.WebACLSummary.ReadOnly] =
      AwsError.unwrapOptionField("summary", summary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CreateWebAclResponse
  ) extends zio.aws.wafv2.model.CreateWebAclResponse.ReadOnly {
    override val summary: Optional[zio.aws.wafv2.model.WebACLSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summary())
        .map(value => zio.aws.wafv2.model.WebACLSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CreateWebAclResponse
  ): zio.aws.wafv2.model.CreateWebAclResponse.ReadOnly = new Wrapper(impl)
}
