package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CustomRequestHandling(
    insertHeaders: Iterable[zio.aws.wafv2.model.CustomHTTPHeader]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CustomRequestHandling = {
    import CustomRequestHandling.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CustomRequestHandling
      .builder()
      .insertHeaders(insertHeaders.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CustomRequestHandling.ReadOnly =
    zio.aws.wafv2.model.CustomRequestHandling.wrap(buildAwsValue())
}
object CustomRequestHandling {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CustomRequestHandling
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CustomRequestHandling =
      zio.aws.wafv2.model.CustomRequestHandling(insertHeaders.map { item =>
        item.asEditable
      })
    def insertHeaders: List[zio.aws.wafv2.model.CustomHTTPHeader.ReadOnly]
    def getInsertHeaders: ZIO[Any, Nothing, List[
      zio.aws.wafv2.model.CustomHTTPHeader.ReadOnly
    ]] = ZIO.succeed(insertHeaders)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CustomRequestHandling
  ) extends zio.aws.wafv2.model.CustomRequestHandling.ReadOnly {
    override val insertHeaders
        : List[zio.aws.wafv2.model.CustomHTTPHeader.ReadOnly] = impl
      .insertHeaders()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.CustomHTTPHeader.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CustomRequestHandling
  ): zio.aws.wafv2.model.CustomRequestHandling.ReadOnly = new Wrapper(impl)
}
