package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.ResponseContent
import scala.jdk.CollectionConverters.*
final case class CustomResponseBody(
    contentType: zio.aws.wafv2.model.ResponseContentType,
    content: ResponseContent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CustomResponseBody = {
    import CustomResponseBody.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CustomResponseBody
      .builder()
      .contentType(contentType.unwrap)
      .content(ResponseContent.unwrap(content): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CustomResponseBody.ReadOnly =
    zio.aws.wafv2.model.CustomResponseBody.wrap(buildAwsValue())
}
object CustomResponseBody {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CustomResponseBody
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CustomResponseBody =
      zio.aws.wafv2.model.CustomResponseBody(contentType, content)
    def contentType: zio.aws.wafv2.model.ResponseContentType
    def content: ResponseContent
    def getContentType
        : ZIO[Any, Nothing, zio.aws.wafv2.model.ResponseContentType] =
      ZIO.succeed(contentType)
    def getContent: ZIO[Any, Nothing, ResponseContent] = ZIO.succeed(content)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CustomResponseBody
  ) extends zio.aws.wafv2.model.CustomResponseBody.ReadOnly {
    override val contentType: zio.aws.wafv2.model.ResponseContentType =
      zio.aws.wafv2.model.ResponseContentType.wrap(impl.contentType())
    override val content: ResponseContent =
      zio.aws.wafv2.model.primitives.ResponseContent(impl.content())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CustomResponseBody
  ): zio.aws.wafv2.model.CustomResponseBody.ReadOnly = new Wrapper(impl)
}
