package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DefaultAction(
    block: Optional[zio.aws.wafv2.model.BlockAction] = Optional.Absent,
    allow: Optional[zio.aws.wafv2.model.AllowAction] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.DefaultAction = {
    import DefaultAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.DefaultAction
      .builder()
      .optionallyWith(block.map(value => value.buildAwsValue()))(_.block)
      .optionallyWith(allow.map(value => value.buildAwsValue()))(_.allow)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.DefaultAction.ReadOnly =
    zio.aws.wafv2.model.DefaultAction.wrap(buildAwsValue())
}
object DefaultAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.DefaultAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.DefaultAction =
      zio.aws.wafv2.model.DefaultAction(
        block.map(value => value.asEditable),
        allow.map(value => value.asEditable)
      )
    def block: Optional[zio.aws.wafv2.model.BlockAction.ReadOnly]
    def allow: Optional[zio.aws.wafv2.model.AllowAction.ReadOnly]
    def getBlock: ZIO[Any, AwsError, zio.aws.wafv2.model.BlockAction.ReadOnly] =
      AwsError.unwrapOptionField("block", block)
    def getAllow: ZIO[Any, AwsError, zio.aws.wafv2.model.AllowAction.ReadOnly] =
      AwsError.unwrapOptionField("allow", allow)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.DefaultAction
  ) extends zio.aws.wafv2.model.DefaultAction.ReadOnly {
    override val block: Optional[zio.aws.wafv2.model.BlockAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.block())
        .map(value => zio.aws.wafv2.model.BlockAction.wrap(value))
    override val allow: Optional[zio.aws.wafv2.model.AllowAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allow())
        .map(value => zio.aws.wafv2.model.AllowAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.DefaultAction
  ): zio.aws.wafv2.model.DefaultAction.ReadOnly = new Wrapper(impl)
}
