package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.wafv2.model.primitives.{LockToken, ResourceArn}
import scala.jdk.CollectionConverters.*
final case class DeleteFirewallManagerRuleGroupsRequest(
    webACLArn: ResourceArn,
    webACLLockToken: LockToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsRequest = {
    import DeleteFirewallManagerRuleGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsRequest
      .builder()
      .webACLArn(ResourceArn.unwrap(webACLArn): java.lang.String)
      .webACLLockToken(LockToken.unwrap(webACLLockToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsRequest.ReadOnly =
    zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsRequest
      .wrap(buildAwsValue())
}
object DeleteFirewallManagerRuleGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsRequest =
      zio.aws.wafv2.model
        .DeleteFirewallManagerRuleGroupsRequest(webACLArn, webACLLockToken)
    def webACLArn: ResourceArn
    def webACLLockToken: LockToken
    def getWebACLArn: ZIO[Any, Nothing, ResourceArn] = ZIO.succeed(webACLArn)
    def getWebACLLockToken: ZIO[Any, Nothing, LockToken] =
      ZIO.succeed(webACLLockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsRequest
  ) extends zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsRequest.ReadOnly {
    override val webACLArn: ResourceArn =
      zio.aws.wafv2.model.primitives.ResourceArn(impl.webACLArn())
    override val webACLLockToken: LockToken =
      zio.aws.wafv2.model.primitives.LockToken(impl.webACLLockToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsRequest
  ): zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsRequest.ReadOnly =
    new Wrapper(impl)
}
